#!/bin/bash

alias la='ls -lah'

# Configure apache vhost
colordiff /etc/apache2/sites-available/000-default.conf /vagrant/examples/000-default.conf
sudo cp /vagrant/examples/000-default.conf /etc/apache2/sites-available/000-default.conf
sudo /etc/init.d/apache2 restart

# Configure fpm pool
colordiff /etc/php/7.0/fpm/pool.d/www.conf /vagrant/examples/www.conf
sudo cp /vagrant/examples/www.conf /etc/php/7.0/fpm/pool.d/www.conf
sudo /etc/init.d/php7.0-fpm restart

# Create database with utf8
mysql -u root -proot -e 'CREATE DATABASE typo3 CHARACTER SET utf8 COLLATE utf8_general_ci;'

# Setup composer
mkdir /home/ubuntu/bin
curl -sS https://getcomposer.org/installer | php -- --install-dir=/home/ubuntu/bin --filename=composer

# Setup web folder
sudo chown -R ubuntu:ubuntu /var/www/html/
rm -rf /var/www/html/index.html

cd /var/www/html

# Install TYPO3
rm -rf /var/www/html
ln -s /vagrant /var/www/html
mysql -uroot -proot typo3 < /vagrant/dump.sql
cp /vagrant/examples/AdditionalConfiguration.php /var/www/html/typo3/typo3conf/
